/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric.platform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.impactdev.impactor.api.platform.PlatformComponent;
import net.impactdev.impactor.api.platform.PlatformType;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.platform.ImpactorPlatformInfo;
import net.impactdev.impactor.fabric.platform.components.FabricComponent;
import net.impactdev.impactor.fabric.platform.components.FabricMinecraftComponent;

public final class FabricPlatformInfo
extends ImpactorPlatformInfo {
    private final List<String> exclusions = Lists.newArrayList((Object[])new String[]{"minecraft", "fabricloader", "java"});

    FabricPlatformInfo() {
        super(PlatformType.FABRIC);
    }

    @Override
    public List<PluginMetadata> plugins() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(this::translate).collect(Collectors.toList());
    }

    @Override
    public Optional<PluginMetadata> plugin(String id) {
        return FabricLoader.getInstance().getModContainer(id).map(ModContainer::getMetadata).map(this::translate);
    }

    @Override
    protected void printComponents(PrettyPrinter printer) {
        printer.add("Components:");
        printer.table("Name", "Version");
        for (PlatformComponent component : this.components()) {
            printer.tr(component.name(), component.version());
        }
        printer.hr('-');
        List<ModContainer> mods = FabricLoader.getInstance().getAllMods().stream().filter(info -> !this.exclusions.contains(info.getMetadata().getId())).filter(info -> info.getContainingMod().isEmpty()).collect(Collectors.toList());
        printer.newline().add("Mods (%d)", mods.size());
        mods.forEach(mod -> this.printModContainer((ModContainer)mod, printer, 0, false));
    }

    @Override
    protected void specifyComponents(Set<PlatformComponent> set) {
        set.add(new FabricMinecraftComponent());
        set.add(new FabricComponent());
    }

    private PluginMetadata translate(ModMetadata metadata) {
        return PluginMetadata.builder().id(metadata.getId()).name(metadata.getName()).version(metadata.getVersion().getFriendlyString()).description(metadata.getDescription()).build();
    }

    private void printModContainer(ModContainer target, PrettyPrinter printer, int level, boolean last) {
        StringBuilder builder = new StringBuilder();
        for (int depth = 0; depth < level; ++depth) {
            builder.append(depth == 0 ? "\t" : "   | ");
        }
        builder.append(level == 0 ? "\t" : "  ");
        builder.append(level == 0 ? "-" : (last ? " \\--" : " |--"));
        builder.append(' ').append(target.getMetadata().getId()).append(' ');
        builder.append(target.getMetadata().getVersion().getFriendlyString());
        printer.add(builder.toString());
        ArrayList<ModContainer> nestedMods = new ArrayList<ModContainer>(target.getContainedMods());
        nestedMods.sort(Comparator.comparing(nestedMod -> nestedMod.getMetadata().getId()));
        if (!nestedMods.isEmpty()) {
            Iterator iterator2 = nestedMods.iterator();
            while (iterator2.hasNext()) {
                ModContainer next = (ModContainer)iterator2.next();
                this.printModContainer(next, printer, level + 1, !iterator2.hasNext());
            }
        }
    }
}

